param([string]$InstanceName, [string]$DatabaseName, [string]$CustomSQLName)

$StrLength = 4096

if ($CustomSQLName){$ComputerName=$CustomSQLName}
else {$ComputerName=(Get-WmiObject Win32_Computersystem).name}

if ($InstanceName -match "SQLServer"){$InstanceName = ""}
else {$InstanceName = $InstanceName.Replace('MSSQL$',"")
	$InstanceName = $InstanceName.Replace("'","")
}

$ConnectionString = $ComputerName + '\' + $InstanceName
#write-output "ConnString - $ConnectionString"

$Query = @"
	SELECT 
	 SUM(IIF(max_size = -1, 268435456,max_size)) /1024 * 8
     FROM
      sys.master_files a
      JOIN sys.databases b ON b.database_id = a.database_id
     WHERE a.type = 1 AND b.name = '$DatabaseName'
"@
try{
    $Datatable = New-Object System.Data.DataTable
    
    $Connection = New-Object System.Data.SQLClient.SQLConnection
    $Connection.ConnectionString = "server=$ConnectionString;database='master';trusted_connection=true;"
    $Connection.Open()
    $Command = New-Object System.Data.SQLClient.SQLCommand
    $Command.Connection = $Connection
    $Command.CommandText = $Query
    $Reader = $Command.ExecuteReader()
    $Datatable.Load($Reader)
    $Connection.Close()
 
#    $Datatable.Rows | FT *


if (($Datatable.rows).count -ge 1)
{
    $FormatedData = $Datatable.Rows | FW | out-string
    $FormatedData = [int]$FormatedData
    if($FormatedData.Length -gt $StrLength) {$FormatedData = $FormatedData.substring(0, $StrLength)}
    write-output $FormatedData
}
else{write-output "0"}
}

Catch
{write-output "Result: none"
$ConnectionString
$Exception = $_.Exception.Message
if($Exception.Length -gt $StrLength) {$Exception = $Exception.substring(0, $StrLength)}
write-output $Exception
}