param($InstanceNames, $DatabaseNames, $THR_LOGFLUSHWAITS, $THR_LOGFLUSHWAITTIME, $THR_DBLOGGROWTHS, $THR_DBLOGSHRINKS, $THR_DBLOGUSED, $THR_SPIDWAITTIME, $CUSTOMSQLNAME)
$sep="'","'"
function splitParams ([string]$param) { $param.Split($sep,0)[1].split(':')}
#"Params: $customInstances, $dbs, $THR_LOGFLUSHWAITS, $THR_LOGFLUSHWAITTIME,$THR_DBLOGGROWTHS,$THR_DBLOGSHRINKS,$THR_DBLOGUSED,$THR_SPIDWAITTIME"
# Split input parameters, initialize arrays for DBs, properties and output

$dbs=@($DatabaseNames.Split($sep,0)[1].split('#'))
$customInstances=@($InstanceNames.Split($sep,0)[1].split('#'))

$THR_LOGFLUSHWAITS=@(splitParams($THR_LOGFLUSHWAITS))
$THR_LOGFLUSHWAITTIME=@(splitParams($THR_LOGFLUSHWAITTIME))
$THR_DBLOGGROWTHS=@(splitParams($THR_DBLOGGROWTHS))
$THR_DBLOGSHRINKS=@(splitParams($THR_DBLOGSHRINKS))
$THR_DBLOGUSED=@(splitParams($THR_DBLOGUSED))
$THR_SPIDWAITTIME=@(splitParams($THR_SPIDWAITTIME))

#"Params: $customInstances, $dbs, $THR_LOGFLUSHWAITS, $THR_LOGFLUSHWAITTIME,$THR_DBLOGGROWTHS,$THR_DBLOGSHRINKS,$THR_DBLOGUSED,$THR_SPIDWAITTIME"
#exit
$DBsToDiscover=@()
$props=@{}
$json=@{data=@()}

function ConnectToSQLServer ([string]$ConnectionString)
{
	$ConnectionStringFull = "Server=" + $ConnectionString + ";Integrated Security=SSPI;MultipleActiveResultSets=true;Connection Timeout=2"
	#write-output $ConnectionStringFull
	try{
		$SQLConn = New-Object System.Data.SqlClient.SqlConnection($ConnectionStringFull);
		$SQLConn.Open();
		#write-output $SQLConn.Status
	}
	Catch [Exception] {
 		write-output $_.Exception.GetType().FullName; 
  		write-output $_.Exception.Message; 
	}
	return $SQLConn
}

if ($CUSTOMSQLNAME){$SQLServer=$CUSTOMSQLNAME}
else {$SQLServer=(Get-WmiObject Win32_Computersystem).name}
#write-output "SQLServer: $SQLServer"

$Instances = (get-itemproperty 'HKLM:\SOFTWARE\Microsoft\Microsoft SQL Server').InstalledInstances
$basename = @()
foreach ($InstanceName in $Instances)
{
	if ($InstanceName -eq "MSSQLSERVER"){$ConnectInstance = ""} else {$ConnectInstance = $InstanceName}
	$connectionString = "$SQLServer\$ConnectInstance"
	$connection = ConnectToSQLServer($connectionString)
    if ($connection.State -eq "Open")
    {
	    # Create a request directly to MSSQL
	    $SqlCmd = New-Object System.Data.SqlClient.SqlCommand  
	    $SqlCmd.CommandText = "select @@servicename as instance, name from sys.databases"
	    $SqlCmd.Connection = $Connection
	    $SqlAdapter = New-Object System.Data.SqlClient.SqlDataAdapter
	    $SqlAdapter.SelectCommand = $SqlCmd
	    $DataSet = New-Object System.Data.DataSet
	    $SqlAdapter.Fill($DataSet) > $null
	    $Connection.Close()
	    
	    $basename += @($DataSet.Tables[0])
    }
}


#Check if threshold value for current DB object is empty. If it is - set its value to default
function checkifempty($threshold)
{
  if (![string]::IsNullOrWhitespace($threshold[1]))
  {
    if ([string]::IsNullOrWhitespace($threshold[1].split("#")[$i].split("~")[$d])) 
    {
      $threshold[1].split("#")[$i]
    }
    else
    {
      $threshold[1].split("#")[$i].split("~")[$d]
    }
  }
  else { $threshold[0] } 
}

# Create an object for each DB specified in 'DatabaseNames' parameter
for ($i=0; $i -lt $customInstances.count; $i++) 
{
  $instancedbs=$dbs[$i].split("~")
  for ($d=0; $d -lt $instancedbs.count; $d++)
  {    
    $props=@{
    'DBName'=$instancedbs[$d]; 
    'InstanceName'=$customInstances[$i];
     'THR_LOGFLUSHWAITS'=checkifempty($THR_LOGFLUSHWAITS);
     'THR_LOGFLUSHWAITTIME'=checkifempty($THR_LOGFLUSHWAITTIME);
     'THR_DBLOGGROWTHS'=checkifempty($THR_DBLOGGROWTHS);
     'THR_DBLOGSHRINKS'=checkifempty($THR_DBLOGSHRINKS);
     'THR_DBLOGUSED'=checkifempty($THR_DBLOGUSED);
     'THR_SPIDWAITTIME'=checkifempty($THR_SPIDWAITTIME);
    }
    
    $DB=New-Object -TypeName psobject -Property $props
    $DBsToDiscover+=$DB
  }
}

foreach ($Base in $basename)
{       
  if($Base.Item("Instance") -eq "MSSQLSERVER") {$InstanceName = "SQLServer"} else {$InstanceName = "MSSQL$" + $Base.Item("Instance")} 
  $DBName = $Base.Item("Name")

  if (@($DBsToDiscover.InstanceName).Contains($InstanceName) -and @($DBsToDiscover.DBName).Contains($DBName))
  {
    for ($i=0; $i -lt $DBsToDiscover.Count; $i++)
    {
      if ($DBName -eq @($DBsToDiscover.DBName)[$i] -and $InstanceName -eq @($DBsToDiscover.InstanceName)[$i])
      {
        $json.data+=@{
          "{#DBINSTANCE}"=$InstanceName;
          "{#DBNAME}"=$DBName;
          "{#THR_LOGFLUSHWAITS}"=@($DBsToDiscover.THR_LOGFLUSHWAITS)[$i];
          "{#THR_LOGFLUSHWAITTIME}"=@($DBsToDiscover.THR_LOGFLUSHWAITTIME)[$i];
          "{#THR_DBLOGGROWTHS}"=@($DBsToDiscover.THR_DBLOGGROWTHS)[$i];
          "{#THR_DBLOGSHRINKS}"=@($DBsToDiscover.THR_DBLOGSHRINKS)[$i];
          "{#THR_DBLOGUSED}"=@($DBsToDiscover.THR_DBLOGUSED)[$i];
          "{#THR_SPIDWAITTIME}"=@($DBsToDiscover.THR_SPIDWAITTIME)[$i];
        }
      }
    }     
  }
  else   
  {
    $json.data+=@{
      "{#DBINSTANCE}"=$InstanceName;
      "{#DBNAME}"=$DBName;
      "{#THR_LOGFLUSHWAITS}"=@($THR_LOGFLUSHWAITS[0])
      "{#THR_LOGFLUSHWAITTIME}"=@($THR_LOGFLUSHWAITTIME[0])
      "{#THR_DBLOGGROWTHS}"=@($THR_DBLOGGROWTHS[0])
      "{#THR_DBLOGSHRINKS}"=@($THR_DBLOGSHRINKS[0])
      "{#THR_DBLOGUSED}"=@($THR_DBLOGUSED[0])
      "{#THR_SPIDWAITTIME}"=@($THR_SPIDWAITTIME[0])
    }
  }
}
$json | ConvertTo-Json