param([string]$InstanceName, [int]$WaitMinutes,[string]$CustomSQLName)

if ($WaitMinutes -gt 0)
{$StrLength = 4096

if ($CustomSQLName){$ComputerName=$CustomSQLName}
else {$ComputerName=(Get-WmiObject Win32_Computersystem).name}

if ($InstanceName -like "SQLServer"){$InstanceName = ""}
else {$InstanceName = $InstanceName.Replace('MSSQL$',"")
      $InstanceName = $InstanceName.Replace("'","")}

$ConnectionString = $ComputerName + '\' + $InstanceName
$ConnectionString
$Query = @"
SELECT		 S.spid as [BlockedSPID],
                 S.blocked as [BlockedBy],
                 S.waittime,
                 S.cmd,
                 S.hostname,
                 S.program_name,
                 D.name as DBName,
                 left(H.text, 200) as [sql_text]
                 from dbo.sysprocesses S with(nolock)
                 	inner join dbo.sysdatabases D
                  	on S.dbid = D.dbid
                 	cross apply sys.dm_exec_sql_text(S.sql_handle) H
                 		where
                   		((S.blocked <> 0 and S.waittime > $WaitMinutes * 60 * 1000)
                   		or
				(S.blocked = 0 and S.spid in (select blocked from dbo.sysprocesses where blocked <> 0 and waittime > $WaitMinutes * 60 * 1000)))
"@
try{
    $Datatable = New-Object System.Data.DataTable
    $Connection = New-Object System.Data.SQLClient.SQLConnection
    $Connection.ConnectionString = "server=$ConnectionString;database='master';trusted_connection=true;Connection Timeout=15"
    $Connection.Open()
    $Command = New-Object System.Data.SQLClient.SQLCommand
    $Command.Connection = $Connection
    $Command.CommandText = $Query
    $Reader = $Command.ExecuteReader()
    $Datatable.Load($Reader)
    $Connection.Close()

if (($Datatable.rows).count -ge 1)
   {$FormatedData = $Datatable.Rows | select-object BlockedSPID, BlockedBy, cmd, program_name, DBName | FL | out-string
    if($FormatedData.Length -gt $StrLength) {$FormatedData = $FormatedData.substring(0, $StrLength)}
    write-output $FormatedData}

else{write-output "Result: none"}
}
Catch
{write-output "Result: none"
$ConnectionString
$ExceptMessage = $_.Exception.Message
if ($ExceptMessage.Length -gt $StrLength) {$ExceptMessage = $ExceptMessage.substring(0, $StrLength)}
$ExceptMessage
}
}
else{write-output "Result: none"}