$json=@{data=@()}

function ConnectToSQLServer ([string]$ConnectionString) {
	$ConnectionStringFull = "Server=" + $ConnectionString + ";Integrated Security=SSPI;MultipleActiveResultSets=true;Connection Timeout=2"
	try{
		$SQLConn = New-Object System.Data.SqlClient.SqlConnection($ConnectionStringFull);
		$SQLConn.Open();
	}
	Catch [Exception] {
 		write-output $_.Exception.GetType().FullName;
  		write-output $_.Exception.Message;
	}
	return $SQLConn
}

$SQLServer=(Get-WmiObject Win32_Computersystem).name

$Instances = (get-itemproperty 'HKLM:\SOFTWARE\Microsoft\Microsoft SQL Server').InstalledInstances
$basename = @()
foreach ($InstanceName in $Instances)
{
	if ($InstanceName -eq "MSSQLSERVER") {
		$ConnectInstance = ""
	} else {
		$ConnectInstance = $InstanceName
	}
	$connectionString = "$SQLServer\$ConnectInstance"
	$connection = ConnectToSQLServer($connectionString)
    if ($connection.State -eq "Open") {
	    $SqlCmd = New-Object System.Data.SqlClient.SqlCommand
	    $SqlCmd.CommandText = "select @@servicename as instance, d.database_name from sys.dm_hadr_database_replica_cluster_states d join sys.dm_hadr_availability_replica_states r on d.replica_id = r.replica_id and r.is_local = 1"
	    $SqlCmd.Connection = $Connection
	    $SqlAdapter = New-Object System.Data.SqlClient.SqlDataAdapter
	    $SqlAdapter.SelectCommand = $SqlCmd
	    $DataSet = New-Object System.Data.DataSet
	    $SqlAdapter.Fill($DataSet) > $null
	    $Connection.Close()

	    $basename += @($DataSet.Tables[0])
    }
}
$replicas_instances = @()
foreach ($Base in $basename)
{
  if($Base.Item("Instance") -eq "MSSQLSERVER") {
	  $InstanceName = "SQLServer"
  } else {
	  $InstanceName = "MSSQL$" + $Base.Item("Instance")
      $replicas_instances += $InstanceName
  }
#  $DBName = $Base.Item("Database_name")
#
#  $json.data+=@{
#    "{#DBINSTANCE}"=$InstanceName;
#    "{#DBNAME}"=$DBName;
#  }
}

$replicas_instances = $replicas_instances | select -Unique

foreach ($replica in $replicas_instances)
{
   $json.data+=@{
     "{#DBINSTANCE}"=$replica;
   }
}

$json | ConvertTo-Json

# DELIVERY TEST