param([Int32]$topN=5)

$currentUTCdate = ((Get-Date).ToUniversalTime().ToString("yyyy-MM-dd HH:mm:ss"))
Write-Output "For help, see data on top 5 Memory consuming processes as of  $currentUTCdate UTC :"

function round($value) { [Decimal]::Round($value, 2) }
$Path=@{ Name="Path"; Expression={$_.Group[0].Path} }
$MemTotal = (Get-WMIObject Win32_ComputerSystem).TotalPhysicalMemory
$GroupPMem=@{ Name="%Mem"; Expression={round((($_.Group | measure-object WS -sum).sum * 100 /$MemTotal))} }

write-Host Top $topN Memory Processes:

get-process | ? {$_.ProcessName -notmatch "Memory Compression"} | 
group-object ProcessName | select Name, $GroupPMem, $Path | sort %Mem -desc | select -f $topN | ft -a | out-string -width 200
Write-Output "More info about collecting data https://bitbucket.wolterskluwer.io/projects/OI/repos/zabbix/browse/agent/windows/scripts/get_topN_memory_processes.ps1" 