param([Int32]$topN=5)

$currentUTCdate = ((Get-Date).ToUniversalTime().ToString("yyyy-MM-dd HH:mm:ss"))
Write-Output "For help, see data on top 5 CPU consuming processes as of  $currentUTCdate UTC :"

function round($value) { [Decimal]::Round($value, 2) }

$proc_filter = "NOT (Name ='_Total' OR Name='Idle')"
$proc_meta = gwmi win32_process -filter $proc_filter
$proc_perf = gwmi Win32_PerfFormattedData_PerfProc_Process -filter $proc_filter

$PCpu = @{Name="%CPU"; Expression={round($_.PercentProcessorTime / $env:NUMBER_OF_PROCESSORS)}}
$CommandLine = @{Name="CommandLine"; Expression={$proc_id = $_.IDProcess; $proc_meta | ?{$_.ProcessId -eq $proc_id} | select -ExpandProperty CommandLine}}
$proc_perf | sort PercentProcessorTime -descending | select -f 5 Name, $PCpu, $CommandLine | ft -a | out-string -width 500
Write-Output "More info about collecting data https://bitbucket.wolterskluwer.io/projects/OI/repos/zabbix/browse/agent/windows/scripts/get_topN_cpu_processes_v2.ps1"