param($VolumeName, $Metric)
Import-Module FailoverClusters

if ($VolumeName -ne "Discovery"){
   $VolumeName = $VolumeName -replace '[\\\[\\\]]'
	$value = Get-ClusterSharedVolume -Name $VolumeName | select -Expand SharedVolumeInfo | Select-Object -ExpandProperty Partition | % { $_.$metric }
	return $value
   }
else {
   $objs = @()
   $csvs = Get-ClusterSharedVolume
   foreach ( $csv in $csvs )
   {
      $csvinfos = $csv | select -Property Name -ExpandProperty SharedVolumeInfo
      foreach ( $csvinfo in $csvinfos )
      {
         $obj = New-Object PSObject -Property $NonEmptyProperties @{
            "{#NAME}"        = $csv.Name 
            Path        = $csvinfo.FriendlyVolumeName
            Size        = $csvinfo.Partition.Size
            FreeSpace   = $csvinfo.Partition.FreeSpace
            UsedSpace   = $csvinfo.Partition.UsedSpace
            PercentFree = $csvinfo.Partition.PercentFree
            PercentUsed = (100-$csvinfo.Partition.PercentFree)
         }
         $objs += $obj
      }
   }
   #$objs
   return $objs | ConvertTo-Json
   #return $objs | ConvertTo-Csv -NoTypeInformation -Delimiter "," | % {$_ -replace '"',''} 
   #$objs | ft -auto Name,Path,@{ Label = "Size(GB)" ; Expression = { "{0:N2}" -f ($_.Size/1024/1024/1024) } },@{ Label = "Free(GB)" ; Expression = { "{0:N2}" -f ($_.FreeSpace/1024/1024/1024) } },@{ Label = "Used(GB)" ; Expression = { "{0:N2}" -f ($_.UsedSpace/1024/1024/1024) } },@{ Label = "Free(%)" ; Expression = { "{0:N2}" -f ($_.PercentFree) } },@{ Label = "Used(%)" ; Expression = { "{0:N2}" -f ($_.PercentUsed) } }
}