param([string]$DFSFILE)
[string]$TaskName = "OI Zabbix DFS Monitoring Task"
Start-ScheduledTask -TaskName "$TaskName"

[String]$DFSR = Get-Content $DFSFILE

[xml]$xmlDoc = New-Object system.Xml.XmlDocument 
$xmlDoc.LoadXml($DFSR) 
 
$properties = $xmlDoc.getElementsByTagName("result"); 
 
#$properties | FL channel, value
$idx = 1

write-host "{"
write-host " `"data`":[`n"

foreach ($Element in $properties)
{ 
    if ($idx -lt $Properties.count)
    {
        $line= "{ `"{#CHANNEL}`" : `"" + $element.channel + "`" ,"     
        write-host $line
        $line= "  `"{#BACKLOG}`" : `"" + 	$element.value + "`" },"
        write-host $line

    }
    elseif ($idx -ge $Properties.count)
    {
	$line= "{ `"{#CHANNEL}`" : `"" + $element.channel + "`" ,"
	write-host $line
        $line= "  `"{#BACKLOG}`" : `"" + $element.value + "`" }"
        write-host $line
    }
    $idx++;
}

write-host
write-host " ]"
write-host "}"