param ([string]$DefLogsPaths, [string]$DefPatterns, [string]$DefThrCritMatchCounts)

[array]$Logs = $DefLogsPaths.split('#')
[array]$Patterns = $DefPatterns.split('#')
[array]$ThrCritCounts = $DefThrCritMatchCounts.split('#')

$idx = 1
write-output "["

for ($i = 0; $i -lt $Logs.count; $i++)
{

    $CurrentLogJson = $Logs[$i] -replace '\\','\\'
    $CurrentLog = $Logs[$i] -replace '\\\\','\'

	$CurrentRegExp = $Patterns[$i]
    [array]$CurrentRegExpArray = $Patterns[$i].split('~')
    $CurrentCritThr = $ThrCritCounts[$i]

    $CurrentPatternOccurences = Select-String -CaseSensitive -Path $CurrentLog -Pattern $CurrentRegExpArray | measure

    if ($idx -lt $Logs.count)
    {
        $line= "{`"logname`":`"" + $CurrentLogJson + "`","
        write-output $line
        $line= "`"regexp`":`"" + $CurrentRegExp + "`","
        write-output $line
        $line= "`"critthr`":`"" + $CurrentCritThr + "`","
        write-output $line
        $line= "`"occurences`":`"" + $CurrentPatternOccurences.Count + "`"},"
        write-output $line
    }
    elseif ($idx -ge $Logs.count)
    {
        $line= "{`"logname`":`"" + $CurrentLogJson + "`","
        write-output $line
        $line= "`"regexp`":`"" + $CurrentRegExp + "`","
        write-output $line
        $line= "`"critthr`":`"" + $CurrentCritThr + "`","
        write-output $line
        $line= "`"occurences`":`"" + $CurrentPatternOccurences.Count + "`"}"
        write-output $line
    }
    $idx++;

}

write-output "]"