param([string]$ServerName,[string]$user,[string]$pwd,[string]$database,[int]$Threshold)

$StrLength = 4096

if ($Threshold -ge 0)
	{
	$connectionString = "Server=$ServerName;uid=$user;pwd=$pwd;Database=$database;Integrated Security=False;"
	$connection = New-Object System.Data.SqlClient.SqlConnection
	$connection.ConnectionString = $connectionString
	$query = "SELECT [Request_ID],[Request_Server_ID],[Request_State],[Time_Submitted],[Time_Started],GETDATE() as [Current_Time],[Request_User_Email] FROM [dbo].[CCHRequestAuto] where Request_State = 'INPR' and DATEDIFF(MINUTE, Time_Started , CURRENT_TIMESTAMP) > $Threshold"

	try 
		{$connection.Open() 
		$command = $connection.CreateCommand()
		$command.CommandText  = $query
		$result = $command.ExecuteReader()
		$table = new-object "System.Data.DataTable"
		$table.Load($result)
	
		#[string]$table1 = $table | out-string
	
		if ($table -ne $null)
			{
			write-output "Result: true"
			if($table.Length -gt $StrLength) {$table = $table.substring(0, $StrLength)}
			write-output $table | FL
			}
		else 
			{
			write-output "Result: none"
			}
		}
	catch
		{
		write-output "Result: none"
		$Exception = $_.Exception.Message
		if($Exception.Length -gt $StrLength) {$Exception = $Exception.substring(0, $StrLength)}
		write-output $Exception
		}
	finally 
		{$connection.Close()}
}
else {write-output "Result: none"}
